define(['angular'], function (angular) {
    'use strict';

    return function ($http) {
        return {

            findInArray: function (array, testFunction) {
                if (!Array.isArray(array)) {
                    throw new Error('Array expected.  Usage: findInArray(array, callbackFn)');
                }

                if (typeof testFunction !== 'function') {
                    throw new Error('Function expected.  Usage: findInArray(array, callbackFn)');
                }

                var i = 0;
                var foundItem;

                while (i < array.length) {
                    var currItem = array[i];

                    if (testFunction(currItem)) {
                        foundItem = currItem;
                        break;
                    }

                    i++;
                }

                return foundItem;
            },

            initParams: function (httpConfig) {
                httpConfig.params = angular.extend(httpConfig.params || {}, {
                    _format: 'json'
                });

                var queryParams = [];
                if (httpConfig.params.startDate && httpConfig.url !== '/pgd-fhir-services/v1/fhir/Goal') {


                    queryParams.push('date=ge' + httpConfig.params.startDate);
                    delete httpConfig.params.startDate;
                }

                if (httpConfig.params.endDate && httpConfig.url !== '/pgd-fhir-services/v1/fhir/Goal') {
                    queryParams.push('date=le' + httpConfig.params.endDate);
                    delete httpConfig.params.endDate;
                }
                if (httpConfig.params.status && httpConfig.url === '/pgd-fhir-services/v1/fhir/Goal') {
                    queryParams.push('status=' + 'in-progress');


                    delete httpConfig.params.status;
                }

                httpConfig.url += queryParams.length ? '?' + queryParams.join('&') : '';
            },

            transformRequest: function (data, headersGetter) {
                var headers = headersGetter();

                delete headers['Authorization'];
                headers['Content-Type'] = 'application/json';

                return data ? JSON.stringify(data) : undefined;
            },
            
            sendRequest: function (httpConfig) {
                httpConfig = httpConfig || {};

                this.initParams(httpConfig);

                httpConfig.transformRequest = this.transformRequest;

                return $http(httpConfig);
            }
        };
    };
});